local Weight = require "components/weight"
local lume = require "util.lume"

local EquipmentStatDisplay = {
    [EQUIPMENT_STATS.s.RARITY] =
    {
        default = ITEM_RARITY.s.COMMON,
    },
    [EQUIPMENT_STATS.s.WEIGHT] =
    {
        icon = "images/icons_ftf/stat_weight.tex",
        displayvalue_fn = function(stat, amount)
            local str = Weight.GetWeightStringForValue(amount)
            return str
        end,

        deltavalue_fn = function(value, delta)
            return value + delta
        end
        --hide_delta_value = true,
    },
    [EQUIPMENT_STATS.s.ARMOUR] =
    {
        icon = "images/ui_ftf/ic_stat_defend.tex",
        default = 0,
        round = 0.001,

        displayvalue_fn = function(stat, amount)
            -- Mush the number a bit
            amount = amount*50

            -- And round it
            amount = lume.round(amount, 1)
            return amount
        end,

        tt_fn = function(stat, amount)

        end,
    },
    [EQUIPMENT_STATS.s.HP] =
    {
        icon = "images/icons_ftf/stat_health.tex",
        default = 0,
    },
    [EQUIPMENT_STATS.s.DMG_MULT] =
    {
        icon = "images/icons_ftf/stat_weapon.tex",
        default = 0,
        deltavalue_fn = function(amount, delta)
			-- Add 1 to delta values so that the -1 in displayvalue_fn() makes sense.
            delta = delta + 1
            delta = delta - 0.1
			return delta
        end,

        displayvalue_fn = function(stat, amount)
			-- Subtract 1 because the base value is 1 and we want to re-normalize that to 0.
            amount = amount-1

            -- A weapon with 1.0 damage mult should not display as "0", so let's make it display at "10" instead.
            amount = amount + 0.1

            -- Mush the number a bit.
            amount = amount*50

            return amount
        end,
    },
    [EQUIPMENT_STATS.s.DMG] =
    {
        icon = "images/icons_ftf/stat_weapon.tex",
        default = 0,
        round = 1,
    },
    [EQUIPMENT_STATS.s.CRIT] =
    {
        icon = "images/icons_ftf/stat_crit_chance.tex",
        default = 0,
        percent = true,
    },
    [EQUIPMENT_STATS.s.SPEED] =
    {
        icon = "images/icons_ftf/stat_speed.tex",
        default = 0,
        percent = true,
    },
    [EQUIPMENT_STATS.s.LUCK] =
    {
        icon = "images/icons_ftf/stat_luck.tex",
        default = 0,
        percent = true,
    },
    [EQUIPMENT_STATS.s.CRIT_MULT] =
    {
        icon = "images/icons_ftf/stat_crit_damage.tex",
        default = 0,
        percent = true,
        tt_fn = function(stat, amount)
            local str = STRINGS.UI.EQUIPMENT_STATS[string.upper(stat)].desc
            local mod = amount
            mod = mod * 100
            return string.format(str, mod)
        end,
    },
    [EQUIPMENT_STATS.s.FOCUS_MULT] =
    {
        icon = "images/icons_ftf/stat_focus.tex",
        default = 0,
        percent = true,
        tt_fn = function(stat, amount)
            local str = STRINGS.UI.EQUIPMENT_STATS[string.upper(stat)].desc
            amount = amount * 100
            return string.format(str, amount)
        end,
    },
}
return EquipmentStatDisplay
